/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.tile;

import gloridifice.watersource.client.render.tile.AnimationTile;
import gloridifice.watersource.common.item.StrainerBlockItem;
import gloridifice.watersource.common.recipe.WaterFilterRecipe;
import gloridifice.watersource.common.tile.WaterFilterDownTile;
import gloridifice.watersource.registry.ParticleRegistry;
import gloridifice.watersource.registry.TileEntityTypesRegistry;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class WaterFilterUpTile
extends AnimationTile
implements ITickableTileEntity {
    LazyOptional<FluidTank> upTank = LazyOptional.of(this::createFluidHandler);
    LazyOptional<ItemStackHandler> strainer = LazyOptional.of(this::createStrainerItemStackHandler);
    LazyOptional<ItemStackHandler> props = LazyOptional.of(this::createPropsItemStackHandler);
    private int heightAmount = 0;
    final int capacity;
    private int processTicks = 0;
    boolean flag;

    public WaterFilterUpTile(int capacity) {
        super(TileEntityTypesRegistry.WATER_FILTER_UP_TILE);
        this.capacity = capacity;
    }

    public LazyOptional<FluidTank> getUpTank() {
        return this.upTank;
    }

    public LazyOptional<ItemStackHandler> getStrainer() {
        return this.strainer;
    }

    public LazyOptional<ItemStackHandler> getProps() {
        return this.props;
    }

    public int getProcessTicks() {
        return this.processTicks;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.upTank.ifPresent(fluidTank -> fluidTank.readFromNBT(compound.func_74775_l("upTank")));
        this.strainer.ifPresent(itemStackHandler -> itemStackHandler.deserializeNBT(compound.func_74775_l("strainer")));
        this.props.ifPresent(itemStackHandler -> itemStackHandler.deserializeNBT(compound.func_74775_l("props")));
        this.processTicks = ((IntNBT)compound.func_74781_a("processTicks")).func_150287_d();
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbtTag);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.upTank.ifPresent(fluidTank -> compound.func_218657_a("upTank", (INBT)fluidTank.writeToNBT(new CompoundNBT())));
        this.strainer.ifPresent(itemStackHandler -> compound.func_218657_a("strainer", itemStackHandler.serializeNBT()));
        this.props.ifPresent(itemStackHandler -> compound.func_218657_a("props", itemStackHandler.serializeNBT()));
        compound.func_218657_a("processTicks", (INBT)IntNBT.func_229692_a_((int)this.processTicks));
        return super.func_189515_b(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (!this.field_145846_f) {
            if (CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.equals(cap)) {
                return this.upTank.cast();
            }
            if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.equals(cap)) {
                return this.strainer.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
        TileEntity downTile;
        this.processTicks %= 8000;
        ++this.processTicks;
        if (this.processTicks % 20 == 0 && (downTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof WaterFilterDownTile) {
            this.strainer.ifPresent(strainerHandler -> this.props.ifPresent(propsHandler -> {
                ItemStack strainerStack = strainerHandler.getStackInSlot(0);
                int speed = propsHandler.getStackInSlot(0).func_77973_b() == Items.field_205158_fa ? 25 : 10;
                this.upTank.ifPresent(fluidTankUp -> {
                    WaterFilterRecipe recipe = WaterFilterRecipe.getRecipeFromInput(this.field_145850_b, strainerStack, fluidTankUp.getFluid().getFluid());
                    ((WaterFilterDownTile)downTile).getDownTank().ifPresent(fluidTankDown -> {
                        if (recipe != null && fluidTankDown.getFluid().getAmount() < fluidTankDown.getCapacity()) {
                            this.flag = true;
                            if (fluidTankDown.isEmpty() || fluidTankDown.getFluid().getFluid().func_207187_a(recipe.getOutputFluid())) {
                                fluidTankDown.fill(new FluidStack(recipe.getOutputFluid(), speed), IFluidHandler.FluidAction.EXECUTE);
                                fluidTankUp.drain(speed, IFluidHandler.FluidAction.EXECUTE);
                            }
                            if (this.processTicks % 10000 / speed == 0 && strainerStack.func_77984_f()) {
                                strainerHandler.setStackInSlot(0, StrainerBlockItem.damageItem(strainerStack, 1));
                            }
                        } else {
                            this.flag = false;
                        }
                    });
                });
            }));
        }
    }

    private void addParticles() {
        BlockPos pos = this.func_174877_v();
        Random random = new Random();
        this.func_145831_w().func_217404_b((IParticleData)ParticleRegistry.FLUID_WATER, true, 0.125 + (double)pos.func_177958_n() + random.nextDouble() * 0.75, (double)pos.func_177956_o(), 0.125 + (double)pos.func_177952_p() + random.nextDouble() * 0.75, 0.0, -0.2, 0.0);
    }

    private ItemStackHandler createStrainerItemStackHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                WaterFilterUpTile.this.refresh();
                WaterFilterUpTile.this.func_70296_d();
                super.onContentsChanged(slot);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return ItemTags.func_199903_a().func_199910_a(new ResourceLocation("watersource", "strainers")).func_230235_a_((Object)stack.func_77973_b());
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (stack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                this.validateSlotIndex(slot);
                ItemStack existing = (ItemStack)this.stacks.get(slot);
                if (simulate) {
                    if (!existing.func_190926_b()) {
                        Block.func_180635_a((World)WaterFilterUpTile.this.field_145850_b, (BlockPos)WaterFilterUpTile.this.field_174879_c, (ItemStack)existing);
                        this.extractItem(slot, existing.func_190916_E() + 1, false);
                    }
                    this.stacks.set(slot, (Object)stack);
                }
                this.onContentsChanged(slot);
                return ItemStack.field_190927_a;
            }
        };
    }

    private ItemStackHandler createPropsItemStackHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                WaterFilterUpTile.this.refresh();
                WaterFilterUpTile.this.func_70296_d();
                super.onContentsChanged(slot);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.func_77973_b() == Items.field_205158_fa;
            }
        };
    }

    private FluidTank createFluidHandler() {
        return new FluidTank(this.capacity){

            protected void onContentsChanged() {
                WaterFilterUpTile.this.refresh();
                WaterFilterUpTile.this.func_70296_d();
                super.onContentsChanged();
            }

            public boolean isFluidValid(FluidStack stack) {
                return !stack.getFluid().getAttributes().isLighterThanAir() && stack.getFluid().getAttributes().getTemperature() < 500;
            }
        };
    }

    public int getFluidAmount() {
        return ((FluidTank)this.upTank.orElse(null)).getFluidAmount();
    }

    private void updateHeight() {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            if (this.heightAmount > this.getFluidAmount()) {
                this.heightAmount -= Math.max(1, (this.heightAmount - this.getFluidAmount()) / 10);
            } else if (this.heightAmount < this.getFluidAmount()) {
                this.heightAmount += Math.max(1, (this.getFluidAmount() - this.heightAmount) / 10);
            }
        }
    }

    public float getHeight() {
        this.updateHeight();
        return 0.75f * (float)this.heightAmount / (float)this.capacity;
    }
}

